/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.model;

import choco.Choco;
import choco.IPretty;
import choco.kernel.common.IIndex;
import choco.kernel.common.util.iterators.DisposableIterator;
import choco.kernel.common.util.tools.ArrayUtils;
import choco.kernel.common.util.tools.IteratorUtils;
import choco.kernel.common.util.tools.StringUtils;
import choco.kernel.model.IConstraintList;
import choco.kernel.model.IVariableArray;
import choco.kernel.model.Model;
import choco.kernel.model.constraints.Constraint;
import choco.kernel.model.variables.Variable;
import java.io.Serializable;
import java.util.Iterator;

public class VariableArray
implements IVariableArray,
Serializable {
    private static final long serialVersionUID = -4465055351650054924L;
    protected static final Constraint[] NO_CONSTRAINTS = new Constraint[0];
    private Variable[] variables;
    private Variable[] extractedVariables;

    public VariableArray() {
    }

    public VariableArray(Variable[] variables) {
        this.variables = (Variable[])variables.clone();
    }

    @Override
    public final int getNbVars() {
        return this.variables.length;
    }

    @Override
    public final Variable getVariable(int i) {
        return this.variables[i];
    }

    @Override
    public final DisposableIterator<Variable> getVariableIterator() {
        return IteratorUtils.iterator(this.extractVariables());
    }

    @Override
    public final Variable[] getVariables() {
        return this.variables;
    }

    protected final void setVariables(Variable variable) {
        this.variables = new Variable[]{variable};
        this.cancelExtractVariables();
    }

    protected final void setVariables(Variable[] variables) {
        this.variables = variables;
        this.cancelExtractVariables();
    }

    @Override
    public final void replaceBy(Variable outVar, Variable inVar) {
        long idx = outVar.getIndex();
        for (int i = 0; i < this.variables.length; ++i) {
            if (this.variables[i].getIndex() != idx) continue;
            this.variables[i] = inVar;
        }
        this.cancelExtractVariables();
    }

    protected final void replaceByConstantAt(int outVarIndex, int val) {
        this.variables[outVarIndex] = Choco.constant(val);
        this.cancelExtractVariables();
    }

    protected Variable[] doExtractVariables() {
        return (Variable[])ArrayUtils.getNonRedundantObjects(Variable.class, (IIndex[])this.variables);
    }

    protected final void cancelExtractVariables() {
        this.extractedVariables = null;
    }

    protected final void forceExtractVariables() {
        this.cancelExtractVariables();
        this.extractedVariables = this.doExtractVariables();
    }

    @Override
    public final Variable[] extractVariables() {
        if (this.extractedVariables == null) {
            this.extractedVariables = this.doExtractVariables();
        }
        return this.extractedVariables;
    }

    @Override
    public String pretty() {
        return StringUtils.pretty((IPretty[])this.variables);
    }

    protected final class VConstraintsDataStructure
    implements IConstraintList {
        @Override
        public void _addConstraint(Constraint c) {
            for (Variable v : VariableArray.this.variables) {
                v._addConstraint(c);
            }
        }

        @Override
        public void _removeConstraint(Constraint c) {
            for (Variable v : VariableArray.this.variables) {
                v._removeConstraint(c);
            }
        }

        @Override
        public boolean _contains(Constraint c) {
            for (Variable v : VariableArray.this.variables) {
                if (v._contains(c)) continue;
                return false;
            }
            return true;
        }

        @Override
        public void removeConstraints() {
            for (Variable v : VariableArray.this.variables) {
                v.removeConstraints();
            }
        }

        @Override
        public Constraint getConstraint(int i) {
            return null;
        }

        @Override
        public Iterator<Constraint> getConstraintIterator(final Model m) {
            return new Iterator<Constraint>(){
                int n = 0;
                Iterator<Constraint> it;
                Constraint c;
                {
                    this.it = VariableArray.this.variables.length > 0 ? VariableArray.this.variables[this.n].getConstraintIterator(m) : null;
                    this.c = null;
                }

                @Override
                public boolean hasNext() {
                    while (true) {
                        if (this.it == null) {
                            return false;
                        }
                        if (this.it.hasNext()) {
                            this.c = this.it.next();
                            if (!Boolean.TRUE.equals(m.contains(this.c))) continue;
                            return true;
                        }
                        if (this.n >= VariableArray.this.variables.length) break;
                        ++this.n;
                        if (this.n >= VariableArray.this.variables.length) continue;
                        this.it = VariableArray.this.variables[this.n].getConstraintIterator(m);
                    }
                    return false;
                }

                @Override
                public Constraint next() {
                    return this.c;
                }

                @Override
                public void remove() {
                    this.it.remove();
                }
            };
        }

        @Override
        public Constraint[] getConstraints() {
            return NO_CONSTRAINTS;
        }

        @Override
        public int getNbConstraint(Model m) {
            int sum = 0;
            for (Variable v : VariableArray.this.variables) {
                sum += v.getNbConstraint(m);
            }
            return sum;
        }
    }
}

