/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.common.util.bitmask;

import choco.kernel.common.util.bitmask.IBitMask;
import choco.kernel.common.util.bitmask.StringMask;
import java.util.List;

public final class BitMask
implements IBitMask {
    private long bitMask;

    public BitMask() {
        this.bitMask = 0L;
    }

    public BitMask(BitMask toCopy) {
        this.bitMask = toCopy.bitMask;
    }

    @Override
    public long getBitMask() {
        return this.bitMask;
    }

    public void clear() {
        this.bitMask = 0L;
    }

    public boolean isEmpty() {
        return this.bitMask == 0L;
    }

    public boolean contains(long mask) {
        return (this.bitMask & mask) == mask;
    }

    public boolean or(IBitMask ... settings) {
        for (IBitMask setting : settings) {
            if (!this.contains(setting)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(IBitMask setting) {
        return this.contains(setting.getBitMask());
    }

    public void set(long mask) {
        this.bitMask |= mask;
    }

    public void toggle(long mask) {
        this.bitMask ^= mask;
    }

    public void unset(long mask) {
        this.bitMask &= mask ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public void read(List<String> options, StringMask ... settings) {
        for (StringMask setting : settings) {
            if (!options.contains(setting.getOption())) continue;
            this.set(setting);
        }
    }

    public void unset(IBitMask ... settings) {
        for (IBitMask setting : settings) {
            this.unset(setting.getBitMask());
        }
    }

    public void set(IBitMask ... settings) {
        for (IBitMask setting : settings) {
            this.set(setting.getBitMask());
        }
    }

    public String toString() {
        return String.valueOf(this.bitMask);
    }
}

