/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf;

import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.DataBlockStorage;

public class DataBlockResults {
    DataBlockStorage data;
    int start;

    public void clear() {
        this.data = null;
    }

    public int getDim() {
        return this.data.getDim();
    }

    public void prepare(int dim, int start, int end) {
        this.clear();
        this.start = start;
        this.data = new DataBlockStorage(dim, end - start);
    }

    public DataBlock datablock(int t) {
        if (this.data == null || t < this.start) {
            return null;
        }
        return this.data.block(t - this.start);
    }

    public DataBlock item(int idx) {
        return this.data.item(idx);
    }

    public void save(int t, DataBlock P) {
        int st = t - this.start;
        if (st < 0) {
            return;
        }
        int capacity = this.data.getCapacity();
        if (capacity <= st) {
            this.data.resize(st + 1);
        }
        this.data.save(st, P);
    }

    public int getCurrentSize() {
        return this.data.getCurrentSize();
    }

    public int getStartSaving() {
        return this.start;
    }

    public boolean isInitialized() {
        return this.data.getDim() > 0;
    }

    public void rescale(double factor) {
        this.data.rescale(factor);
    }
}

