/*
 * Decompiled with CFR 0.152.
 */
package standalone_spreadsheet.org.dhatim.fastexcel;

import java.util.Arrays;

public final class BitMatrix
implements Cloneable {
    private int width;
    private int height;
    private int rowSize;
    private int[] bits;

    public BitMatrix(int dimension) {
        this(dimension, dimension);
    }

    public BitMatrix(int width, int height) {
        if (width < 1 || height < 1) {
            throw new IllegalArgumentException("Both dimensions must be greater than 0");
        }
        this.width = width;
        this.height = height;
        this.rowSize = (width + 31) / 32;
        this.bits = new int[this.rowSize * height];
    }

    private BitMatrix(int width, int height, int rowSize, int[] bits) {
        this.width = width;
        this.height = height;
        this.rowSize = rowSize;
        this.bits = bits;
    }

    public boolean get(int x, int y) {
        int offset = y * this.rowSize + x / 32;
        return (this.bits[offset] >>> (x & 0x1F) & 1) != 0;
    }

    public void set(int x, int y) {
        int offset;
        int n = offset = y * this.rowSize + x / 32;
        this.bits[n] = this.bits[n] | 1 << (x & 0x1F);
    }

    public void unset(int x, int y) {
        int offset;
        int n = offset = y * this.rowSize + x / 32;
        this.bits[n] = this.bits[n] & ~(1 << (x & 0x1F));
    }

    public void flip(int x, int y) {
        int offset;
        int n = offset = y * this.rowSize + x / 32;
        this.bits[n] = this.bits[n] ^ 1 << (x & 0x1F);
    }

    public void flip() {
        int max = this.bits.length;
        for (int i = 0; i < max; ++i) {
            this.bits[i] = ~this.bits[i];
        }
    }

    public void clear() {
        int max = this.bits.length;
        for (int i = 0; i < max; ++i) {
            this.bits[i] = 0;
        }
    }

    public void setRegion(int left, int top, int width, int height) {
        if (top < 0 || left < 0) {
            throw new IllegalArgumentException("Left and top must be nonnegative");
        }
        if (height < 1 || width < 1) {
            throw new IllegalArgumentException("Height and width must be at least 1");
        }
        int right = left + width;
        int bottom = top + height;
        if (bottom > this.height || right > this.width) {
            throw new IllegalArgumentException("The region must fit inside the matrix");
        }
        for (int y = top; y < bottom; ++y) {
            int offset = y * this.rowSize;
            for (int x = left; x < right; ++x) {
                int n = offset + x / 32;
                this.bits[n] = this.bits[n] | 1 << (x & 0x1F);
            }
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getRowSize() {
        return this.rowSize;
    }

    public boolean equals(Object o) {
        if (!(o instanceof BitMatrix)) {
            return false;
        }
        BitMatrix other = (BitMatrix)o;
        return this.width == other.width && this.height == other.height && this.rowSize == other.rowSize && Arrays.equals(this.bits, other.bits);
    }

    public int hashCode() {
        int hash = this.width;
        hash = 31 * hash + this.width;
        hash = 31 * hash + this.height;
        hash = 31 * hash + this.rowSize;
        hash = 31 * hash + Arrays.hashCode(this.bits);
        return hash;
    }

    public String toString() {
        return this.toString("X ", "  ");
    }

    public String toString(String setString, String unsetString) {
        return this.buildToString(setString, unsetString, "\n");
    }

    @Deprecated
    public String toString(String setString, String unsetString, String lineSeparator) {
        return this.buildToString(setString, unsetString, lineSeparator);
    }

    private String buildToString(String setString, String unsetString, String lineSeparator) {
        StringBuilder result = new StringBuilder(this.height * (this.width + 1));
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                result.append(this.get(x, y) ? setString : unsetString);
            }
            result.append(lineSeparator);
        }
        return result.toString();
    }

    public BitMatrix clone() {
        return new BitMatrix(this.width, this.height, this.rowSize, (int[])this.bits.clone());
    }
}

