/*
 * Decompiled with CFR 0.152.
 */
package standalone_spreadsheet.nbbrd.io.text;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Stream;
import lombok.NonNull;
import standalone_spreadsheet.internal.io.InternalResource;
import standalone_spreadsheet.internal.io.text.AndThenTextParser;
import standalone_spreadsheet.internal.io.text.FunctionalTextParser;
import standalone_spreadsheet.internal.io.text.InternalParser;
import standalone_spreadsheet.internal.io.text.InternalTextResource;
import standalone_spreadsheet.internal.io.text.LegacyFiles;
import standalone_spreadsheet.internal.io.text.WithCharsetFileParser;
import standalone_spreadsheet.nbbrd.io.FileParser;
import standalone_spreadsheet.nbbrd.io.Resource;
import standalone_spreadsheet.nbbrd.io.function.IOFunction;
import standalone_spreadsheet.nbbrd.io.function.IOSupplier;
import standalone_spreadsheet.nbbrd.io.sys.ProcessReader;
import standalone_spreadsheet.nbbrd.io.text.Parser;

public interface TextParser<T> {
    @NonNull
    default public T parseChars(@NonNull CharSequence source) throws IOException {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        try (Reader reader = InternalTextResource.openReader(source);){
            T t = this.parseReader(reader);
            return t;
        }
    }

    @NonNull
    default public T parseFile(@NonNull File source, @NonNull Charset encoding) throws IOException {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (encoding == null) {
            throw new NullPointerException("encoding is marked non-null but is null");
        }
        try (BufferedInputStream bufferedResource = new BufferedInputStream(LegacyFiles.newInputStream(source));){
            T t = this.parseStream(bufferedResource, encoding);
            return t;
        }
    }

    @NonNull
    default public T parsePath(@NonNull Path source, @NonNull Charset encoding) throws IOException {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (encoding == null) {
            throw new NullPointerException("encoding is marked non-null but is null");
        }
        Optional<File> file = Resource.getFile(source);
        return file.isPresent() ? this.parseFile(file.get(), encoding) : this.parseStream(() -> Files.newInputStream(source, new OpenOption[0]), encoding);
    }

    @NonNull
    default public T parseProcess(@NonNull Process process, @NonNull Charset encoding) throws IOException {
        if (process == null) {
            throw new NullPointerException("process is marked non-null but is null");
        }
        if (encoding == null) {
            throw new NullPointerException("encoding is marked non-null but is null");
        }
        try (BufferedReader resource = ProcessReader.newReader(encoding, process);){
            T t = this.parseReader(resource);
            return t;
        }
    }

    @NonNull
    default public T parseProcess(@NonNull ProcessBuilder processBuilder, @NonNull Charset encoding) throws IOException {
        if (processBuilder == null) {
            throw new NullPointerException("processBuilder is marked non-null but is null");
        }
        if (encoding == null) {
            throw new NullPointerException("encoding is marked non-null but is null");
        }
        return this.parseProcess(processBuilder.start(), encoding);
    }

    @NonNull
    default public T parseProcess(@NonNull List<String> command, @NonNull Charset encoding) throws IOException {
        if (command == null) {
            throw new NullPointerException("command is marked non-null but is null");
        }
        if (encoding == null) {
            throw new NullPointerException("encoding is marked non-null but is null");
        }
        return this.parseProcess(new ProcessBuilder(command), encoding);
    }

    @NonNull
    default public T parseResource(@NonNull Class<?> type, @NonNull String name, @NonNull Charset encoding) throws IOException {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (encoding == null) {
            throw new NullPointerException("encoding is marked non-null but is null");
        }
        try (InputStream resource = Resource.newInputStream(type, name);){
            T t = this.parseStream(resource, encoding);
            return t;
        }
    }

    @NonNull
    default public T parseReader(@NonNull IOSupplier<? extends Reader> source) throws IOException {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        try (Reader resource = InternalTextResource.openReader(source);){
            T t = this.parseReader(resource);
            return t;
        }
    }

    @NonNull
    default public T parseStream(@NonNull IOSupplier<? extends InputStream> source, @NonNull Charset encoding) throws IOException {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (encoding == null) {
            throw new NullPointerException("encoding is marked non-null but is null");
        }
        try (InputStream resource = InternalResource.openInputStream(source);){
            T t = this.parseStream(resource, encoding);
            return t;
        }
    }

    @NonNull
    public T parseReader(@NonNull Reader var1) throws IOException;

    @NonNull
    public T parseStream(@NonNull InputStream var1, @NonNull Charset var2) throws IOException;

    @NonNull
    default public <V> TextParser<V> andThen(@NonNull IOFunction<? super T, ? extends V> after) {
        if (after == null) {
            throw new NullPointerException("after is marked non-null but is null");
        }
        return new AndThenTextParser<T, V>(this, after);
    }

    @NonNull
    default public FileParser<T> asFileParser(@NonNull Charset encoding) {
        if (encoding == null) {
            throw new NullPointerException("encoding is marked non-null but is null");
        }
        return new WithCharsetFileParser(this, encoding);
    }

    @NonNull
    default public Parser<T> asParser() {
        return this.asParser(InternalParser::doNothing);
    }

    @NonNull
    default public Parser<T> asParser(@NonNull Consumer<? super Throwable> onError) {
        if (onError == null) {
            throw new NullPointerException("onError is marked non-null but is null");
        }
        return chars -> {
            if (chars != null) {
                try {
                    return this.parseChars(chars);
                }
                catch (Throwable ex) {
                    onError.accept(ex);
                }
            }
            return null;
        };
    }

    @NonNull
    public static <T> TextParser<T> onParsingReader(@NonNull IOFunction<? super Reader, ? extends T> function) {
        if (function == null) {
            throw new NullPointerException("function is marked non-null but is null");
        }
        return new FunctionalTextParser<T>(function);
    }

    @NonNull
    public static <T> TextParser<T> onParsingLines(@NonNull Function<? super Stream<String>, ? extends T> function) {
        if (function == null) {
            throw new NullPointerException("function is marked non-null but is null");
        }
        return new FunctionalTextParser<T>(IOFunction.checked(function).compose(InternalTextResource::asLines));
    }

    @NonNull
    public static <T> TextParser<T> onParsingLines(@NonNull Collector<? super String, ?, ? extends T> collector) {
        if (collector == null) {
            throw new NullPointerException("collector is marked non-null but is null");
        }
        return TextParser.onParsingLines((? super Stream<String> stream) -> stream.collect(collector));
    }
}

