/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.view.graph.undirected;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.UndirectedGraphVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.IGraphDeltaMonitor;
import org.chocosolver.solver.variables.events.GraphEventType;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.view.delta.GraphViewDeltaMonitor;
import org.chocosolver.solver.variables.view.graph.UndirectedGraphView;
import org.chocosolver.util.objects.graphs.GraphFactory;
import org.chocosolver.util.objects.graphs.UndirectedGraph;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.procedure.IntProcedure;
import org.chocosolver.util.procedure.PairProcedure;

public class NodeInducedSubgraphView
extends UndirectedGraphView<UndirectedGraphVar> {
    protected UndirectedGraph lb;
    protected UndirectedGraph ub;
    protected UndirectedGraphVar graphVar;
    protected boolean exclude;
    protected ISet nodes;

    public NodeInducedSubgraphView(String name, UndirectedGraphVar graphVar, ISet nodes, boolean exclude) {
        super(name, (Variable[])new UndirectedGraphVar[]{graphVar});
        this.exclude = exclude;
        this.graphVar = graphVar;
        this.nodes = nodes;
        this.lb = GraphFactory.makeNodeInducedSubgraph(this.getModel(), (UndirectedGraph)graphVar.getLB(), (UndirectedGraph)graphVar.getUB(), nodes, exclude);
        this.ub = GraphFactory.makeNodeInducedSubgraph(this.getModel(), (UndirectedGraph)graphVar.getUB(), (UndirectedGraph)graphVar.getUB(), nodes, exclude);
    }

    @Override
    public UndirectedGraph getLB() {
        return this.lb;
    }

    @Override
    public UndirectedGraph getUB() {
        return this.ub;
    }

    @Override
    public int getNbMaxNodes() {
        return this.graphVar.getNbMaxNodes();
    }

    @Override
    public boolean isDirected() {
        return this.graphVar.isDirected();
    }

    @Override
    protected boolean doRemoveNode(int node) throws ContradictionException {
        return this.graphVar.removeNode(node, this);
    }

    @Override
    protected boolean doEnforceNode(int node) throws ContradictionException {
        return this.graphVar.enforceNode(node, this);
    }

    @Override
    protected boolean doRemoveEdge(int from, int to) throws ContradictionException {
        return this.graphVar.removeEdge(from, to, this);
    }

    @Override
    protected boolean doEnforceEdge(int from, int to) throws ContradictionException {
        return this.graphVar.enforceEdge(from, to, this);
    }

    @Override
    public void notify(IEventType event, int variableIdx) throws ContradictionException {
        if ((event.getMask() & GraphEventType.ADD_NODE.getMask()) > 0) {
            this.notifyPropagators(GraphEventType.ADD_EDGE, this);
        }
        this.notifyPropagators(event, this);
    }

    @Override
    public IGraphDeltaMonitor monitorDelta(ICause propagator) {
        return new GraphViewDeltaMonitor(new IGraphDeltaMonitor[]{this.graphVar.monitorDelta(propagator)}){

            @Override
            public void forEachNode(IntProcedure proc, GraphEventType evt) throws ContradictionException {
                IntProcedure filter = i -> {
                    if (NodeInducedSubgraphView.this.exclude && !NodeInducedSubgraphView.this.nodes.contains(i)) {
                        proc.execute(i);
                    } else if (!NodeInducedSubgraphView.this.exclude && NodeInducedSubgraphView.this.nodes.contains(i)) {
                        proc.execute(i);
                    }
                };
                this.deltaMonitors[0].forEachNode(filter, evt);
            }

            @Override
            public void forEachEdge(PairProcedure proc, GraphEventType evt) throws ContradictionException {
                PairProcedure filter = (from, to) -> {
                    if (NodeInducedSubgraphView.this.exclude && !NodeInducedSubgraphView.this.nodes.contains(from) && !NodeInducedSubgraphView.this.nodes.contains(to)) {
                        proc.execute(from, to);
                    } else if (!NodeInducedSubgraphView.this.exclude && NodeInducedSubgraphView.this.nodes.contains(from) && NodeInducedSubgraphView.this.nodes.contains(to)) {
                        proc.execute(from, to);
                    }
                };
                this.deltaMonitors[0].forEachEdge(filter, evt);
            }
        };
    }
}

