/*
 * Decompiled with CFR 0.152.
 */
package eu.kliegr.ac1.rule;

import eu.kliegr.ac1.data.AttributeValue;
import eu.kliegr.ac1.data.Transaction;
import eu.kliegr.ac1.rule.Antecedent;
import eu.kliegr.ac1.rule.Consequent;
import eu.kliegr.ac1.rule.Data;
import eu.kliegr.ac1.rule.Rule;
import eu.kliegr.ac1.rule.RuleInt;
import eu.kliegr.ac1.rule.RuleMultiItem;
import eu.kliegr.ac1.rule.RuleQuality;
import eu.kliegr.ac1.rule.extend.ExtendRuleAnnotation;
import eu.kliegr.ac1.rule.extend.TestRuleAnnotation;
import eu.kliegr.ac1.rule.extend.ValueOrigin;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Node;

public class TestRule
implements RuleInt {
    private static final Logger LOGGER = Logger.getLogger(TestRule.class.getName());
    public RuleQuality testQuality;
    private final Rule rule;

    public TestRule(Rule rule) {
        this.rule = rule;
    }

    public ExtendRuleAnnotation getAnnotation() {
        return this.rule.getAnnotation();
    }

    public Set<Transaction> fireRuleAgainstData(boolean removeCoveredTransaction, Data rmi) {
        int a_plus_b;
        Set<Transaction> antecedentMatch = Collections.newSetFromMap(new HashMap());
        Set<Transaction> antConOverlap = null;
        try {
            antConOverlap = this.getAntecedent().getSupportingTransactions();
            if (antConOverlap == null) {
                a_plus_b = rmi.getDataTable().getCurrentTransactionCount();
                LOGGER.log(Level.FINE, "Default rule coverage:{0}", a_plus_b);
            } else {
                a_plus_b = antConOverlap.size();
            }
        }
        catch (NoSuchElementException e) {
            a_plus_b = 0;
        }
        if (a_plus_b == 0) {
            this.testQuality = new RuleQuality(0, 0);
            return antecedentMatch;
        }
        try {
            if (antConOverlap != null) {
                antecedentMatch.addAll(antConOverlap);
                antConOverlap.retainAll(this.getConsequent().getSupportingTransactions());
            } else {
                antConOverlap = this.getConsequent().getSupportingTransactions();
                antecedentMatch = new HashSet<Transaction>(rmi.getDataTable().getAllCurrentTransactions());
            }
            if (removeCoveredTransaction) {
                antecedentMatch.stream().forEach(t -> rmi.getDataTable().removeTransaction((Transaction)t, false));
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Deregistered transactions: {0}", antecedentMatch.size());
                }
            }
            int a = antConOverlap.size();
            int b = a_plus_b - a;
            this.testQuality = new RuleQuality(a, b);
        }
        catch (NoSuchElementException e) {
            this.testQuality = new RuleQuality(0, a_plus_b);
        }
        return antecedentMatch;
    }

    public String toString() {
        return this.rule.toString();
    }

    @Override
    public int getAntecedentLength() {
        return this.rule.getAntecedentLength();
    }

    @Override
    public float getConfidence() {
        return this.rule.getConfidence();
    }

    @Override
    public Consequent getConsequent() {
        return this.rule.getConsequent();
    }

    @Override
    public Antecedent getAntecedent() {
        return this.rule.getAntecedent();
    }

    @Override
    public int getRID() {
        return this.rule.getRID();
    }

    @Override
    public int getSupport() {
        return this.rule.getSupport();
    }

    @Override
    public Node getXMLRepresentation() {
        return this.rule.getXMLRepresentation();
    }

    public boolean isMatchesInFuzzyBorder(Transaction t) {
        for (RuleMultiItem rmi : this.rule.getAntecedent().getItems()) {
            AttributeValue atVal = t.getValue(rmi.getAttribute());
            TestRuleAnnotation annot = (TestRuleAnnotation)this.rule.getAnnotation();
            ValueOrigin valOrig = annot.getValueOrigin(atVal);
            if (valOrig == null) {
                AttributeValue lower = atVal.getAttribute().getAdjacentLower(atVal, true);
                AttributeValue higher = atVal.getAttribute().getAdjacentHigher(atVal, true);
                ValueOrigin valOrigHigher = annot.getValueOrigin(higher);
                ValueOrigin valOrigLower = annot.getValueOrigin(lower);
                if (valOrigHigher == null || valOrigLower == null) {
                    LOGGER.log(Level.SEVERE, "Transaction {0} is out of bounds of rule {1} for rule item {2}", new Object[]{t, this.rule, rmi.toString(true, true, false)});
                    continue;
                }
                if (valOrigHigher != ValueOrigin.fuzzy_border && valOrigLower != ValueOrigin.fuzzy_border) continue;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Rule {0} matches in the fuzzy border region for {1}", new Object[]{this, rmi});
                }
                return true;
            }
            if (valOrig == ValueOrigin.fuzzy_border) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Rule {0} matches in the fuzzy border region for {1}", new Object[]{this, rmi});
                }
                return true;
            }
            if (!LOGGER.isLoggable(Level.FINE)) continue;
            LOGGER.log(Level.FINE, "Rule {0} matches in {1} region", new Object[]{this, valOrig});
        }
        return false;
    }
}

