## Version 2.4.3
* technical changes for compatibility with the new `ggtree` version.

## Version 2.4.2

#### Bug fixes
* fixed an issue leading to duplicated tip IDs in `SAtree.from.fossils`
* fixed a bug with the `prune.fossil.tips` function in trees with edges of length 0 

#### New functionality
* added ordering options to `SAtree.from.fossils` to choose whether fossils are ordered from the youngest or oldest
* added option for custom X axis label in `plot.fossils`

## Version 2.4.1
* fixed dependency issues due to the new `ggtree` version

## Version 2.4.0

#### New functionality
* added a new structure, the `fbdrange` object, to store the results of FBD-range inferences with budding (e.g. the output of the `sRanges` package for BEAST2)
* added plotting for `fbdrange` objects, showing the oriented tree with stratigraphic ranges

#### Bug fixes
* improved checks on `fossils` object so invalid data types are rejected instead of crashing
* removed `alphanumeric` option from `paleotree.record.to.fossils` as it was incompatible with the fix to data types

## Version 2.3.3

#### New functionality
* `plot.fossils` now integrates an optional extant sampling probability (`rho`) when plotting the reconstructed tree

#### Function changes
* cosmetic changes to `plot.fossils` to make the axis more visible
* colours used for the taxonomy in `plot.fossils` and `plot.taxonomy` are no longer random and can be customized

## Version 2.3.2

#### New functionality
 * `sim.tip.samples` and `sim.extant.samples` can now use tip-specific sampling probabilities by setting argument `rho` to a vector of values instead of a single value.

#### Technical changes
* package `TreeSim` was moved from dependencies to suggested packages. A separate installation of `TreeSim` is now required to run functions `sim.fbd.*`

## Version 2.3.1

#### New functionality
* `sim.fossils.environment` now takes an argument `use.exact.times` which determines if fossil sampling times are recorded exactly or based on interval bounds

#### Bug fixes
* Fixed a bug in `plot.fossils` and `plot.taxonomy` which would not restore plotting parameters properly in some cases.

### Documentation changes
 * Updated the documentation of FBD simulation functions (`sim.fbd.taxa`, `sim.fbd.age`) to clarify the sampling process when `complete = FALSE`

## Version 2.3.0

#### New functionality
* Added Lewis Mk, BM (Brownian motion) and OU (Ornstein-Uhlenbeck) models as options to simulate traits in function `sim.trait.values`.

#### Function changes
* `SAtree.from.fossils` now returns a list of `tree` (the resulting SA tree) and `fossils` (the original `fossils` data.frame updated to include the tip label of each fossil in the SA tree). NB: this change breaks compatibility with previous versions of the function.

## Version 2.2.0

#### New functionality
* Added option to plot the reconstructed tree for a set of fossils and tree objects. This can be done by passing `reconstructed = TRUE` to `plot.fossils` or the objects can be generated separately using the function `reconstructed.tree.fossils.objects`.

##### Functions associated with the occurrence birth-death model
* Added `fossils` as a function argument to the fossil simulation functions so that existing fossil objects can be appended.
* Added `ignore.taxonomy` as a function argument to the fossil simulation functions. If `true` function will not return species or edge info.
* Added `show.unknown` to plotting function. If species or edge info is unknown these fossils will appear next to the tree.

#### Bug fixes
* Fixed bug in `plot.fossils` which led to proxy data being plotted the wrong way round on the x-axis.

## Version 2.1.1

* Fixed a bug in ``sim.fbd.rateshift.taxa`` which led to trees being simulated with the wrong rates. NB: Any dataset simulated with this function before the fix is invalid and needs to be rerun.

## Version 2.1.0

#### New functionality
* The new function ``fossils.to.pyrate`` can be used to convert objects generated by this package into PyRate format.
* The new functions ``fossils.to.BEAST.constraints`` and ``fossils.to.BEAST.start.tree.Rd`` can be used to convert objects generated by this package into BEAST2 format.
* The new functions ``subsample.fossils.oldest``, ``subsample.fossils.oldest.and.youngest``, ``subsample.fossils.uniform`` and ``subsample.fossils.youngest`` can be used to subsample fossil occurrences.

#### Function changes
* The innovative rates model has been integrated into the independent model in the function ``sim.trait.values``. Parameters are unchanged.
* The asymmetric plot function has been renamed ``rangeplot.asymmetric`` and separated from the ``SAtree`` objects.

#### Bugfixes
* Fixed several bugs in ``rangeplot.asymmetric`` that could lead to crashes or plots with missing edges.
* Fixed a bug in ``SAtree.from.fossils`` where ``SAtree`` objects were not created properly when using an empty ``fossils`` object.
