/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Decision_Trees.CART.impurities;

import keel.Algorithms.Decision_Trees.CART.impurities.IImpurityFunction;
import keel.Algorithms.Neural_Networks.NNEP_Common.data.DoubleTransposedDataSet;

public class Gini
implements IImpurityFunction {
    private DoubleTransposedDataSet dataset;

    @Override
    public void setDataset(DoubleTransposedDataSet dataset) {
        this.dataset = dataset;
    }

    @Override
    public double impurities(int[] patterns, double cost) {
        int i;
        int nofoutputs = this.dataset.getNofoutputs();
        int nofpatterns = patterns.length;
        double[] prob_j = new double[nofoutputs];
        for (i = 0; i < patterns.length; ++i) {
            int patternIndex = patterns[i];
            int patternClass = -1;
            for (int j = 0; j < nofoutputs; ++j) {
                if (this.dataset.getAllOutputs()[j][patternIndex] != 1.0) continue;
                patternClass = j;
                break;
            }
            int n = patternClass;
            prob_j[n] = prob_j[n] + 1.0;
        }
        for (i = 0; i < nofoutputs; ++i) {
            prob_j[i] = prob_j[i] / (double)nofpatterns;
        }
        double impurities = 0.0;
        for (int j = 0; j < nofoutputs - 1; ++j) {
            for (int k = j + 1; k < nofoutputs; ++k) {
                impurities += cost * prob_j[j] * prob_j[k];
            }
        }
        impurities = 2.0 * impurities;
        return impurities;
    }
}

